﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Chapter_15
{
    class ResourceToDispose : IDisposable
    {
        private bool m_disposed = false;

        public void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        private void Dispose(bool calledByUser)
        {
            if (!m_disposed)
            {
                if (calledByUser)
                {
                    // można usuwać inne obiekty zarządzane
                }
                // można usuwać zasoby niezarządzane

                m_disposed = true;
            }
        }

        ~ResourceToDispose()
        {
            Dispose(false);
        }
    }

    class DisposePattern
    {
        static void Main()
        {
            ResourceToDispose resource = null;

            try
            {
                resource = new ResourceToDispose();

                // używanie zasobów
            }
            finally
            {
                if (resource != null)
                {
                    resource.Dispose();
                }
            }

            using (ResourceToDispose newResource = new ResourceToDispose())
            {
                // użycie zasobów
            } // automatycznie wywołuje funkcję zwalniającą zasoby
            
        }
    }
}
